/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.Fenetre;
import exceptions.AnnulationException;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import ressources.Images;

public final class Outil {
    private Outil() {
    }

    public static final void message(String titre, String message, int type, Icon icone) {
        JOptionPane.showMessageDialog(Fenetre.getInstance(), message, titre, type, icone);
    }

    public static final void message(String titre, String message, int type, String icone) {
        JOptionPane.showMessageDialog(Fenetre.getInstance(), message, titre, type, Images.getIcone(icone, 64));
    }

    public static final void erreur(String message) {
        Outil.message("Erreur", message, 0, "divers/erreur.png");
    }

    public static final File getFichier(String texte, FileFilter filtre) throws AnnulationException {
        return Outil.getFichier(1, texte, filtre);
    }

    public static final File getFichier(int type, String texte, FileFilter filtre) throws AnnulationException {
        JFileChooser f = new JFileChooser();
        f.setFileFilter(filtre);
        f.setMultiSelectionEnabled(false);
        f.showDialog(null, texte);
        f.setDialogType(type);
        File fichier = f.getSelectedFile();
        if (fichier == null) {
            throw new AnnulationException();
        }
        return fichier;
    }

    public static final String demander(String message) throws AnnulationException {
        String entree = JOptionPane.showInputDialog(message);
        if (entree != null) {
            entree.trim();
        }
        if (entree == null || entree.isEmpty()) {
            throw new AnnulationException();
        }
        return entree;
    }

    public static final boolean confirmer(String message) {
        return JOptionPane.showConfirmDialog(null, message) == 0;
    }

    public static final void wait(int t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

